# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2000,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# -*- perl -*-
# @(#)29   1.70   src/csm/core/pm/NodeUtils.pm.perl, csmcore, csm_rpyxh, rpyxht1f3 9/16/02 16:08:54

# This perl module provides general utilities used by the node commands and a
# few other parts of CSM.

package NodeUtils;
use strict;
# This tells perl to honor locale for sorting, dates, etc.
# More info about locale.pm and perl handling of locales can be found in
# /usr/lib/perl5/5.6.0/locale.pm and the man page for perllocale.
use locale;
use Socket;

my $msgs;
my $distro;
my $useTranslatedMsg;
my %catHashes;
my $csmroot;
my ($MSGCAT, $MSGMAPPATH, $MSGSET);
my $NO_NODERANGES;

my $MSGS = {
			EMsgNO_RES2UNRES => '%1$s:  2651-033 Internal error in NodeUtils.listNodeAttrs() - SkipResolve set, but Res2Unres not set.\n',
		   };

BEGIN
  {
	# this enables us to redirect where it looks for other CSM files during development
	$csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';
	
	$MSGCAT = 'nodecmds.cat';
	if(defined $::MSGMAPPATH){
		$MSGMAPPATH = $ENV{'CSM_ROOT'} ? "$csmroot/msgmaps" : $::MSGMAPPATH;
	}
	else{
		$MSGMAPPATH = "$csmroot/msgmaps";
	}
	$MSGSET = 'NodeUtils';
  }

umask(0022); #this sets umask for all CSM files so that group and world only have read permissions
#to change it, simply use the umask call in your script, after the "use NodeUtils;" line

sub isLinux { if ($^O =~ /^linux/i) { return 1; } else { return 0; } }

sub isAIX { if ($^O =~ /^aix/i) { return 1; } else { return 0; } }


# Return true if this machine is a CSM node.  (Note: it could also be a mgmt svr.)
sub isNode
  {
	# Note: we could check for the csm.client, but that check is slower and OS dependent.
	if (-f '/usr/bin/lsrsrc-api' && -f '/usr/sbin/rsct/bin/IBM.CSMAgentRMd') { return 1; }
	else { return 0; }
  }


# Return true if this machine is a CSM mgmt svr.  (Note: it could also be a node.)
sub isMgmtSvr
  {
	# Note: we could check for the csm.server, but that check is slower and OS dependent.
	if (-f '/usr/bin/lsrsrc-api' && -f '/usr/sbin/rsct/bin/IBM.DMSRMd') { return 1; }
	else { return 0; }
  }


# Return true if the (effective) user running this script is root
sub isRoot { return $> == 0; }


# Return primary hostname and ip address for the given hostname or ip address
# and die if hostname resolution fails
sub getHost
  {
	my ($class, $arg) = @_;
	#print "arg=$arg\n";
	my ($hostname, $ipaddr);
	if (NodeUtils->isIpaddr($arg))
	  {
		$ipaddr = $arg;
		my $packedaddr = inet_aton($ipaddr);
		$hostname = gethostbyaddr($packedaddr, AF_INET);
		if (!length($hostname)) { NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET,"E31",'EMsgBAD_IPADDR',$ipaddr); }
		#print "hostname=$hostname\n";
	  }
	else						# they specified a hostname
	  {
		$hostname = $arg;      # this may be a short hostname
		my ($name, $aliases, $addrtype, $length, @addrs) = gethostbyname($hostname);
		if (!length($name)) { NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET,"E32",'EMsgBAD_HOSTNAME',$hostname); }
		#print "name=$name, # of addrs=$#addrs.\n";
		my $packedaddr = $addrs[0];
		$ipaddr = inet_ntoa($packedaddr);
		$hostname = $name;		# they may have specified a shorter or non-primary name
		#print "ipaddr=$ipaddr, hostname=$hostname\n";
	  }
	return ($hostname, $ipaddr);
  }


# Try to return the primary hostname for the given hostname or ip address.
# If resolution fails, return what was given to us.
sub tryHost
  {
	my ($class, $arg) = @_;
	my $host;
	if (NodeUtils->isIpaddr($arg))
	  {
		my $packedaddr = inet_aton($arg);
		$host = gethostbyaddr($packedaddr, AF_INET);
		if (!length($host)) { $host = $arg; }
	  }
	else						# they specified a hostname, but it may be a short name
	  {
		my ($hostname, $aliases, $addrtype, $length, @addrs) = gethostbyname($arg);
		if (length($hostname)) { $host = $hostname; }
		else { $host = $arg; }
	  }
	return $host;
  }


sub isIpaddr
  {
	#my $addr = shift;
	my ($class, $addr) = @_;
	#print "addr=$addr\n";
	if ($addr =~ /^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/) { return 1; }
	else { return 0; }
  }


# Get and return a msg from a msg hash ref.  Used in a similar way to the msg() function,
# except w/o the severity code.
sub getmsg
  {
	my $class = shift;
	my $msgcat = shift;
	my $msgid = shift;

	# Find the msg and substitute the values left in @_ into the msg
	my $m = $$msgcat{$msgid};
	if (!defined($m)) { $m = NodeUtils->programName() . ": Can not find message $msgid in the message hash variable.\n"; }
	if (NodeUtils->isLinux()) { $m =~ s/^(\s*%\d\$s:\s*)\d{4}-\d{3}\s*/$1/; } # on linux remove the error number
	$m = NodeUtils->substituteValues($m, @_);
	$m = NodeUtils->processNewlines($m);

	return $m;
  }


# Display a msg from a hash reference.  The 1st arg is the hash reference and
# the rest of the args are the same as message().  The msgs in the hash should
# be similar in format to msgs in a catalog.  This means the following:
#  - it should use %1$s for substitution instead of %s
#  - it should include a newline on the end, if desired
#  - if the msg is a warning or error, it should have %1$s: at the beginning
#    to have the program name plugged in
#  - it can have a msg number, but doesn't have to
# A typical use of this routine:
#   NodeUtils->msg($::MSGS,'E2','OPERATION_FAILED',$var);
sub msg
  {
	my $class = shift;
	my $msgcat = shift;

	NodeUtils->messageFromCat($msgcat, '', '', @_);
  }


# Display a msg from a msg catalog to stdout, stderr, or a log file.  This
# function is primarily meant for commands and other code that is sending
# output directly to the user.  Even the log is really a capture of this
# interactive output.  The CLOG API should be used by daemons to log important
# events.
#
# The arguments of the message() function are:
#   severity_code - A string containing 1 or 2 characters indicating the severity
#                   or type of message, then some optional digits containing an exit
#                   code.  Here's the meaning of the 1st character:
#         I - informational
#         W - warning.  This type of message will be sent to stderr.
#             The program name will be plugged into the 1st argument in the msg.
#         E - error.  This type of message will be sent to stderr.
#             The program name will be plugged into the 1st argument in the msg.
#         P - prompt string.  If you don't want the newline at the end of the
#             prompt, don't put it in the message in the catalog.
#         O - program output.
#         V - verbose.  This message should only be displayed if $::VERBOSE is set.
#
#         If $::LOG_FILE_HANDLE is set, the message goes to both the screen and that
#         log file.  (Verbose msgs will be sent to the log file even if $::VERBOSE
#         is not set.)  Optionally, an L can be put before any of the above characters
#         meaning send this message only to the log file handle in $::LOG_FILE_HANDLE.
#         Also, a lowercase L can be put before any of the above characters to mean
#         do NOT send this to the log file, even if $::LOG_FILE_HANDLE is set.
#
#   msg_id - The message to display out of the catalog.  The messages in the catalog
#            should have the newline at the end (if appropriate) and the error
#            message number in it (if an error).
#
#   The rest of the arguments are values to substitute for %s in the msg.
#
#   The global variables that need to be set to specify the message catalog are:
#      MSGCAT - the name of the message catalog containing the messages
#      MSGMAPPATH - the path of the message map containing the messages
#      MSGSET - the name of the msg set withing the catalog.  If not set, it
#               will default to the program name.
#
#   For debugging purposes, if you set the undocumented environment variable
#   CSM_MESSAGE_DEBUG, it will prefix each msg with the msg mnemonic.
#
#   A typical use of this routine would be:
#      $::MSGCAT = 'csmserver.cat';
#      $::MSGMAPPATH = '/opt/csm/msgmaps';
#      ...
#      NodeUtils->message('E2', 'EMsgOPERATION_FAILED', $value1, $value2);
sub message
  {
	shift;  # get rid of the class name
	if (!defined($::MSGCAT) || !defined($::MSGMAPPATH))
	  {
		# Make this msg go through the normal msg processing so we send it to the log file,
		# if appropriate, and we exit with the right rc, if appropriate.
		my $m = NodeUtils->programName() . ":  Internal globabl variable MSGCAT or MSGMAPPATH not defined on call to NodeUtils::message().\n";
		my $hashref = { M => $m };
		NodeUtils->messageFromCat($hashref, '', '', $_[0], 'M');
		return;
	  }
	NodeUtils->messageFromCat($::MSGCAT, $::MSGMAPPATH, $::MSGSET, @_);
  }

# Prints a msg w/o relying on the global vars for the
# msg catalog, msg map path, and msg set.
# The arguments are: msg catalog, msg map path, msg set, and then the same args
# as message().
sub messageFromCat
  {
	# Process the arguments
	shift;  # get rid of the class name
	my $msgcat = shift;
	my $msgmappath = shift;
	my $msgset = shift;
	my $sevcode = shift;
	if ($sevcode=~/V/ && !$::VERBOSE && (!defined($::LOG_FILE_HANDLE) || $sevcode=~/l/)) { return; }
	my $msgid = shift;
	# the rest are the values to be plugged into the msg.  They are in @_

	# Parse the severity code
	my $i=1;  my $logonly=0;  my $nolog=0;
	my $sev = substr($sevcode, 0, 1);    # should be I, W, E, P, O, V, L, or l
	if ($sev eq 'L' || $sev eq 'l')
	  {
		if ($sev eq 'L') { $logonly = 1; }
		else { $nolog = 1; }
		$i = 2;          # logically shift everything by 1 char
		$sev = substr($sevcode, 1, 1);
	  }
	if (!($sev =~ /[WEPVO]/)) { $sev = 'I'; }
	my $code = substr($sevcode, $i);      # optional exit code

	if ($sev =~ /[WE]/) { unshift @_, NodeUtils->programName(); }     # only warnings and errors should have the program name prepended
	
	my $stdouterrf = \*STDOUT;
	my $stdouterrd = '';
	if ($sev =~ /[WE]/)
	  {
		$stdouterrf = \*STDERR;
		$stdouterrd = '1>&2';
	  }

	my $msg;
	# If they pass in a hash reference instead of a msg catalog name, we will
	# get the msg from the hash ref.
	if (ref($msgcat) eq 'HASH') { $msg = NodeUtils->getmsg($msgcat, $msgid, @_); }
	else { $msg = NodeUtils->getMessageFromCat($msgcat, $msgmappath, $msgset, $msgid, @_); }

	# If there is a problem with getMessageFromCat() it returns the error as the msg

	# This is used for debugging
	if ($ENV{'CSM_MESSAGE_DEBUG'}) { $msg = "$msgid: $msg"; }
	
	if (!$logonly && !($sev eq 'V' && !$::VERBOSE)) { print $stdouterrf $msg; }
	if (defined($::LOG_FILE_HANDLE) && !$nolog) { print $::LOG_FILE_HANDLE $msg; }
			
	if (length($code))
	  {
		if (defined($::LOG_FILE_HANDLE)) { close $::LOG_FILE_HANDLE; undef $::LOG_FILE_HANDLE; }
		exit $code;
	  }
  }


# Returns a msg from a catalog.
# Input arguments are: msg id and then the values to be plugged into the msg.
# Note: if this is an EMsg, the 1st value should be the program name.
# This function also uses the same global vars as message().
sub getMessage
  {
	shift;  # get rid of the class name
	if (!defined($::MSGCAT) || !defined($::MSGMAPPATH))
	  {
		return NodeUtils->programName() . ":  Internal globabl variable MSGCAT or MSGMAPPATH not defined on call to NodeUtils::getMessage().\n";
	  }
	return NodeUtils->getMessageFromCat($::MSGCAT, $::MSGMAPPATH, $::MSGSET, @_);
  }

# Returns a msg w/o relying on the global vars for the msg catalog, msg map path, and msg set.
# The arguments are: msg catalog, msg map path, msg set, and then the same args as getMessage().
sub getMessageFromCat
  {
	# Process the arguments
	shift;  # get rid of the class name
	my $msgcat = shift;
	my $msgmappath = shift;
	my $msgset = shift;
	my $msgid = shift;
	# the rest are the values to be plugged into the msg.  They are in @_
	if (!length($msgset)) { $msgset = NodeUtils->programName(); }

	my ($msgnum, $msgsetnum, $defaultmsg) = NodeUtils->getmsgmap($msgmappath, $msgset, $msgcat, $msgid);

	# Check the NLS related env vars to determine if we really have to get the msg from a
	# translated catalog, or if we can just use the default msg from the msg map, because
	# the latter is much faster (does not have to fork a process for each msg).
	if (!NodeUtils->useTranslatedMsg())         # just display default msg from msg map
	  {
		#print "(using default msg...)\n";
		$defaultmsg =~ s/^\'(.*)\'$/$1/s;    # remove the surrounding single quotes
		if (NodeUtils->isLinux()) { $defaultmsg =~ s/^(\s*%\d\$s:\s*|\s*)\d{4}-\d{3}\s*/$1/; }  # on linux remove the error number
		$defaultmsg = NodeUtils->substituteValues($defaultmsg, @_);
		$defaultmsg = NodeUtils->processNewlines($defaultmsg);
		return $defaultmsg;
	  }
	else						# use translated msg from catalog via dspmsg
	  {
		#print "(using translated msg via dspmsg...)\n";
		# We have to quote the values if they have embedded blanks and other funny
		# chars.
		my @values = @_;		# have to make a copy because @_ is readonly
		foreach my $v (@values) { $v = NodeUtils->quote($v); }
		
		# Build the command string and invoke dspmsg
		my $cmd = "/usr/bin/dspmsg -s $msgsetnum $msgcat $msgnum $defaultmsg " . join(' ',@values) . ' 2>&1';
		#print "$cmd\n";
		my $msg = `$cmd`;
		my $rc = $? >> 8;
		if ($rc) { return NodeUtils->programName() . ":  Error running dspmsg to display a message.  Exit code from dspmsg is $rc.  Command: $cmd\nMessage from command: $msg\n"; }
		return $msg;
	  }
  }


# This is sort of the perl equivalent of the ctdspmsg command that finds a msg mnemonic
# and the corresponding msg set, msg number, and default msg in a msg map file.
sub getmsgmap
  {
	my ($class, $msgpath, $msgset, $msgcat, $msgid) = @_;
	my ($catbase) = $msgcat =~ /(.+)\.cat$/;
	my $mapname = "$msgpath/$catbase.$msgset.map";

	# If we have not read the msg map yet, do that
	my $catHash = $catHashes{$mapname};         # this gets a reference to the msg set hash
	if (!defined($catHash))
	  {
		#print "Opening $mapname...\n";
		if (!open(CATFILE, $mapname))
		  {
			my $m = NodeUtils->programName() . ": Can not open message map file $mapname to retrieve message $msgid.\n";
			return (-1, -1, $m);
		  }
		$catHash = {};           # create the hash and save the reference to it
		$catHashes{$mapname} = $catHash;
		while (<CATFILE>)           # this puts the next line into $_
		  {
			my ($mnemonic, $msgnum, $msgset, $defaultmsg) = split(' ', $_, 4);
			chomp($defaultmsg);
			$$catHash{$mnemonic} = [$msgnum, $msgset, $defaultmsg];
		  }
	  }

	# Find the msg in the hash and display it
	my $msgref = $$catHash{$msgid};
	if (!defined($msgref))
	  {
		my $m = NodeUtils->programName() . ": Can not find message $msgid in message map file $mapname.\n";
		return (-1, -1, $m);
	  }

	return @$msgref;      # msgnum, msgset, defaultmsg
  }


# Check the NLS related env vars to determine if we really have to get the msg from a
# translated catalog, or if we can just use the default msg from the msg map.
sub useTranslatedMsg
  {
	if (!defined($useTranslatedMsg))        # cache the result
	  {
		if (!(-x '/usr/bin/dspmsg')) { $useTranslatedMsg = 0; }
		elsif ($ENV{CSM_USE_DSPMSG}) { $useTranslatedMsg = 1; }
		elsif ( defined($ENV{LC_ALL}) && length($ENV{LC_ALL}) )
		  {
			if ( $ENV{LC_ALL} =~ /^(C|POSIX|en_US)$/ ) { $useTranslatedMsg = 0; }
			else { $useTranslatedMsg = 1; }
		  }
		elsif ( defined($ENV{LC_MESSAGES}) && length($ENV{LC_MESSAGES}) )
		  {
			if ( $ENV{LC_MESSAGES} =~ /^(C|POSIX|en_US)$/ ) { $useTranslatedMsg = 0; }
			else { $useTranslatedMsg = 1; }
		  }
		elsif ( defined($ENV{LANG}) && length($ENV{LANG}) )
		  {
			if ( $ENV{LANG} =~ /^(C|POSIX|en_US)$/ )  { $useTranslatedMsg = 0; }
			else { $useTranslatedMsg = 1; }
		  }
		else { $useTranslatedMsg = 0; }         # no locale related vars are set
	  }

	# The only part of this decision we shouldn't cache is whether dspmsg is available,
	# because that can change as we are installing RSCT.
	if (!(-x '/usr/bin/dspmsg')) { return 0; }
	else { return $useTranslatedMsg; }
  }


sub substituteValues
  {
	shift @_;     # get rid of the class argument
	my $msg = shift @_;       # the rest of the arguments are values to be substituted
	
	# Have to substitute the values in the correct order
	my $i = 1;
	foreach my $v (@_)
	  {
		$msg =~ s/%$i\$s/$v/;
		$i++;
	  }
	return $msg;
  }


sub processNewlines
  {
	my ($class, $msg) = @_;
	# For some reason, the presence of $ and @ makes this eval erase the msg, so we
	# must escape them.
	#if ($msg =~ /%\d\$s/) { return $msg; }    # return it unprocessed
	$msg =~ s/([\$\@])/\\$1/sg;
	$msg = 'qq(' . $msg . ')';    # surround with qq() so we can eval it
	$msg = eval $msg;	# this processes the \n correctly
	return $msg;
  }


# Return the name of the perl script currently being executed, w/o the path.
sub programName
  {
	my $progname = $0;
	$progname =~ s|.*/([^/]+?)$|$1|;          # on linux we have to strip the path
	return $progname;
  }


# Run the given cmd and return the output in an array (already chopped).  Alternatively,
# if this function is used in a scalar context, the output is joined into a single string
# with the newlines separating the lines.  Normally, if there is an
# error running the cmd, it will display the error msg and exit with the cmds exit code, unless
# exitcode is given one of the following values:
#   0:  display error msg, but do not exit on error, but set $::RUNCMD_RC to the exit code
#   -1:  do not display error msg and do not exit on error, but set $::RUNCMD_RC to the exit code
#   -2:  do the default behavior (display error msg and exit with cmds exit code)
#   number > 0 - display error msg and exit with the given code
#
# If refoutput is true, then the output will be returned as a reference to an array for
# efficiency.
sub runcmd
  {
	my ($class, $cmd, $exitcode, $refoutput) = @_;
	$::RUNCMD_RC = 0;
	if (!($cmd =~ /2>&1$/)) { $cmd .= ' 2>&1'; }
	NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'V', 'IMsgCMD', $cmd);
	my $outref = [];
	@$outref = `$cmd`;
	if ($?)
	  {
		$::RUNCMD_RC = $? >> 8;
		my $displayerror = 1;
		my $rc;
		if (defined($exitcode) && length($exitcode) && $exitcode != -2)
		  {
			if ($exitcode > 0) { $rc = $exitcode; }    # if not zero, exit with specified code
			elsif ($exitcode <= 0)
			  {
				$rc = '';       # if zero or negative, do not exit
				if ($exitcode < 0) { $displayerror = 0; }
			  }
		  }
		else { $rc = $::RUNCMD_RC; }            # if exitcode not specified, use cmd exit code
		#print "rc=$rc\n";
		if ($displayerror)
		  {
			my $errmsg = '';
			if (NodeUtils->isLinux() && $::RUNCMD_RC == 139) { $errmsg = "Segmentation fault  $errmsg"; }
			else
			  {
				NodeUtils->filterRmcApiOutput($cmd, $outref);   # The error msgs from the -api cmds are pretty messy.  Clean them up a little.
				$errmsg = join('', @$outref);
				chop $errmsg;
			  }
			{ NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, "E$rc", 'EMsgCMD_FAILED', $::RUNCMD_RC, $cmd, $errmsg); }
		  }
		#return undef;    # if rc was set msg() will exit, otherwise return output
	  }
	if ($refoutput)
	  {
		chop(@$outref);
		return $outref;
	  }
	elsif (wantarray)
	  {
		chop(@$outref);
		return @$outref;
	  }
	else
	  {
		my $line = join('', @$outref);
		chop $line;
		return $line;
	  }
  }

sub filterRmcApiOutput
  {
	my ($class, $cmd, $outref) = @_;
	if ($::VERBOSE || !($cmd =~ m|^/usr/bin/\S+-api |)) { return; }        # give as much info as possible, if verbose

	# Figure out the output delimiter
	my ($d) = $cmd =~ / -D\s+(\S+)/;
	if (length($d))
	  {
		$d =~ s/^(\'|\")(.*)(\"|\')$/$2/;       # remove any surrounding quotes
		$d =~ s/([\|\^\*\+\?\.])/\\$1/g;           # escape any chars perl pattern matching would intepret as special chars
	  }
	else { $d = '::'; }       # this is the default output delimiter for the -api cmds
	#$$outref[0] =~ s/^ERROR:\|:.*:\|:.*:\|:.*:\|:.*:\|://;
	#print "d=$d.\n";
	$$outref[0] =~ s/^ERROR${d}.*${d}.*${d}.*${d}.*${d}//;
  }

sub runrmccmd
  {
	#my ($class, $rmccmd, $resclass, $options, $select) = @_;
	my ($class, $rmccmd, $options, $select) = @_;
	my $cmd = "/usr/bin/$rmccmd $options $select";

	return NodeUtils->runcmd($cmd, -2, 1);     # returns a reference to the output array
  }


# Returns the distribution and version of the current machine in the
# form: <distro> <version>
# Returns undef if it is an unknown distro
sub distribution
  {
	if (!defined($distro))
	  {
		# see info.c of the guname tool in gnome-utils for examples of supporting other
		# distros
		if (-f '/etc/redhat-release')
		  {
			my $s = NodeUtils->readFile('/etc/redhat-release');
			#print "s=$s";
			my ($version) = $s =~ /\s(\d+\.\d+)/;
			$distro = 'RedHat ' . $version;
		  }
		elsif (-f '/etc/SuSE-release')
		  {
			my $s = NodeUtils->readFile('/etc/SuSE-release');
			#print "s=$s";
			my $d = 'SuSE';
			if ($s =~ /SLES/s) { $d = 'SLES'; }
			my ($version) = $s =~ /VERSION\s*=\s*(\d+\.\d+)/;
			$distro = "$d $version";
		  }
		else { $distro = ''; }	# this prevents it from trying to find it every time
	  }

	return (length($distro) ? $distro : undef);
  }


# Read a file and return its content
sub readFile
  {
	my ($class, $filename) = @_;
	open(FILE, "<$filename") or return undef;
	my @contents;
	@contents = <FILE>;
	close(FILE);
	if (wantarray){ return @contents; }
	else { return join('',@contents); }
  }


# Quote a string, taking into account embedded quotes.  This function is most
# useful when passing string through the shell to another cmd.  It handles one
# level of embedded double quotes, single quotes, and dollar signs.
sub quote
  {
	my ($class, $str) = @_;
	# if the value has imbedded double quotes, use single quotes.  If it also has
	# single quotes, escape the double quotes.
	if (!($str =~ /\"/))    # no embedded double quotes
	  {
		$str =~ s/\$/\\\$/sg;         # escape the dollar signs
		$str = qq("$str");
	  }
	elsif (!($str =~ /\'/)) { $str = qq('$str'); }   # no embedded single quotes
	else             # has both embedded double and single quotes
	  {
		# Escape the double quotes.  (Escaping single quotes does not seem to work
		# in the shells.)
		$str =~ s/\"/\\\"/sg;
		$str =~ s/\$/\\\$/sg;         # escape the dollar signs
		$str = qq("$str");
	  }
	return $str;
  }


# Return attribute values for a given array of node names.  Before calling
# this function, you can optionally call gatherNodeList() to build the array of node
# names from user input.  You can also optionally call resolveAndUndup()
# separately, if you need access to the resolved list.
# Arguments:
#   arrayref - a reference to the array containing the list of node names.
#              If the list is empty and the WhereStr option is not specified,
#              all the nodes in the ManagedNode class will be selected.
#   attrs - list of attributes that should be returned.  Multiple attribute
#           names can be separate by spaces and/or commas.
#   opthashref - a reference to a hash with the following options:
#        WhereStr - a where string to use instead of a list of nodes.
#        IncludeAttrNames - set to 1 if you want the attribute name to
#                           precede each attribute value.
#        SkipResolve - set to 1 if this function should not do name
#                      resolution on the list of nodes and remove duplicates.
#                      If you set this to 1, you must also pass in Res2Unres
#                      below.
#        Res2Unres - reference to the hash returned by resolveAndUndup().
#        ResourceClass - resource class to get the node info from.  Default is
#                        IBM.ManagedNode.  Make sure the environment variable
#                        CT_MANAGEMENT_SCOPE is set appropriately for the class
#                        being used (for IBM.ManagedNode it should be 1).
#
# Output: returns a reference to an array in which each line will contain
#         the attributes for 1 node, separated by :|:
#         Also $::LISTNODEATTRS_NUMNOTFOUND will be set to the number of nodes
#         that were specified, but not found.
sub listNodeAttrs
  {
	my ($class, $arrayref, $attrs, $opthashref) = @_;

	# Process the select argument
	if (length($attrs)) { $attrs =~ s/[, ]+/::/g; }       # lsrsrc-api needs the attrs separated by ::
	else { $attrs = "'*b0x0020'"; }             # this means return all public attributes

	# Set up where string
	my ($where, $whereattr, $ar2, $res2unres, $dontstripnameattr);
	if ($$opthashref{'ResourceClass'} eq 'IBM.Host') { $whereattr = 'Name'; }
	my $numtobefound = 0;              # 0 means we do not know, i.e. a where string
	if (defined($$opthashref{'WhereStr'})) { $where = NodeUtils->quote($$opthashref{'WhereStr'}); }
	elsif (defined($arrayref) && scalar(@$arrayref))
	  {
		if ($$opthashref{'SkipResolve'})
		  {
			$ar2 = $arrayref;
			if (!defined($$opthashref{'Res2Unres'}))
			  {
				NodeUtils->msg($MSGS, 'W', 'EMsgNO_RES2UNRES');
				$res2unres = {};
			  }
			else { $res2unres = $$opthashref{'Res2Unres'}; }
		  }
		else
		  {
			($ar2, $res2unres) = NodeUtils->resolveAndUndup($arrayref);
		  }
		$where = NodeUtils->buildWhereInList($ar2, $whereattr);
		$numtobefound = scalar(@$ar2);
		$dontstripnameattr = $attrs =~ /(^|::)Name(::|$)/;
		if (!$dontstripnameattr) { $dontstripnameattr = $attrs =~ /\*(b|p)/; }
		$attrs = "Name::$attrs";         # prepend the Name attr so we can tell which ones were found
	  }
	else { $where = '';	}		# this will pick up everything

	# Process other options and run lsrsrc-api cmd
	my $outputFormat = "-D ':|:'";
	my $longFormat = 0;
	if ($$opthashref{'IncludeAttrNames'}) { $outputFormat .= ' -n';  $longFormat = 1; }
	my $resclass = $$opthashref{'ResourceClass'} || 'IBM.ManagedNode';
	my $numfound = 0;
	my $outref = NodeUtils->runrmccmd('lsrsrc-api', "$outputFormat -i", "-s ${resclass}::${where}::$attrs");
	# runrmccmd will exit if the cmd fails
	$numfound = scalar(@$outref);
	my $somenotfound = ($numtobefound && $numfound<$numtobefound);
	
	# Strip the Name attr from the front and figure out which nodes were not found (if applicable)
	if ($numtobefound)
	  {
		foreach my $l (@$outref)
		  {
			# Get the Name attribute and strip it from the beginning of the line
			my ($junk, $name, $rest);
			if ($longFormat) { ($junk, $name, $rest) = split(/:\|:/, $l, 3); }
			else { ($name, $rest) = split(/:\|:/, $l, 2); }
			if (!$dontstripnameattr) { $l = $rest; }
			
			# Remove this node from the hash so we do not try to get it again
			if ($somenotfound) { delete $$res2unres{$name}; }
		  }
	  }
	
	if ($somenotfound)			# some of the specified nodes were not found
	  {
		# The only thing left in the hash are the nodes we did not find.  Build
		# the array of unresolved node names and try those
		my @a;
		foreach my $k (keys %$res2unres) { if ($k ne $$res2unres{$k}) { push @a, $$res2unres{$k}; } }
		if (scalar(@a))
		  {
			$where = NodeUtils->buildWhereInList(\@a, $whereattr);
			$attrs =~ s/^Name:://;
			my $outref2 = NodeUtils->runrmccmd('lsrsrc-api', "$outputFormat -i", "-s ${resclass}::${where}::$attrs");
			$numfound += scalar(@$outref2);
			push @$outref, @$outref2;          # append this to the 1st
		  }
		$::LISTNODEATTRS_NUMNOTFOUND = $numtobefound - $numfound;
	  }
	else           # everything found
	  { $::LISTNODEATTRS_NUMNOTFOUND = 0; }
	
	return $outref;
  }


# Processes all the ways a user can specify nodes to our commands and creates an
# array with the whole list.  The list is checked for duplicates.  A reference to
# the array is returned.  This function will process -n, -N, and -f.  If nodes can
# be passed in as positional args, pass a reference to ARGV (\@ARGV) into this function.
#
# Arguments:
#   arrayref - reference to ARGV (\@ARGV).  NOTE: If you are going to pass an opthashref, 
#                you need to also pass an arrayref before it (the arrayref can reference
#                an empty array - use []).
#   opthashref - a optional reference to a hash with the following keys:
#	    NodeFile - 1 or name of file containing node list.
#		           If 1, it will not look in a file at all.
#		           If undefined, this function will look in the file specified by $::opt_f.
#	    NodeGrp	 - string containing node groups separated by commas or spaces.
#                  If undefined, it will look in $::opt_N.
sub gatherNodeList
  {
	my ($class, $arrayref, $opthashref) = @_;
	my $nodes = [];          # create a reference to an array
	if (defined($arrayref)) { 
		foreach my $e (@$arrayref){
			push @$nodes, NodeUtils->expandRange(split(/[, ]+/,$e));
		}
	}
	if (defined($::opt_n)) { push @$nodes, NodeUtils->expandRange(split(/[, ]+/,$::opt_n)); }
	my $groups = $$opthashref{'NodeGrp'} ? $$opthashref{'NodeGrp'} : $::opt_N;
	if (defined($groups))       # they specified node groups
	  {	
		my $outref = NodeUtils->listNodeGroupExpMem(split(/[, ]+/,$groups));
		foreach my $row (@$outref)
		  {
			my ($name, $nodelist) = $row =~ /^(.+):\|:\{(.*)\}$/;
			push @$nodes, NodeUtils->expandRange(split(/,/, $nodelist));
		  }
	  }
	if(!defined($$opthashref{'NodeFile'}) || $$opthashref{'NodeFile'} ne "1"){
		my $file = $$opthashref{'NodeFile'} ? $$opthashref{'NodeFile'} : $::opt_f;
		if (defined($file))      # read the node list from the file
		  {
			if (open(NODELIST, $file))
			  {
				while (<NODELIST>)
				  {
					chomp($_);
					push @$nodes, NodeUtils->expandRange(split(/[, ]+/,$_));
				  }
				close(NODELIST);
			  }
			else { NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'E', 'EMsgNODELIST_FILE', $file, "$!"); }
		  }
	  }
	return $nodes;
  }


# Will expand a node entry like node01-05 to an array containing node01, node02,
# node03, node04, node05.  An entry like n8-n11 will be expanded to n8, n9, n10,
# n11.  An entry like frame2n5-frame2n12 will be handled correctly.  Some additional
# rules: no spaces in the entry, the roots of the 1st and last node names must
# match.  If the right format is not found, it just returns the whole thing as a
# node name.  This means that most hostnames with dashes in them will still be
# treated as a regular hostname.  The expanding of node ranges can be disabled by
# setting the env var CSM_NO_NODERANGES to anything.
sub expandRange
  {
	shift;     # get rid of class name
	# The rest of @_ or the node names
    #my $node = shift;
	if (!defined($NO_NODERANGES)) { $NO_NODERANGES = defined($ENV{CSM_NO_NODERANGES}); }
	if($NO_NODERANGES) { return @_; }

    my @nodes;
	foreach my $node (@_)
	  {
		if(!($node =~ /-/)) { push @nodes, $node; next; }
		my($front,$end) = split('-', $node, 2);
		# Get the roots of the front part of the range and the last.  If there
		# If there is any problem in the form, assume it is not a range
		my ($fRoot, $fNum) = $front=~/^(.*?)(\d+)$/;
		my ($eRoot, $eNum) = $end=~/^(.*?)(\d+)$/;
		#print "fRoot=$fRoot, fNum=$fNum, eRoot=$eRoot, eNum=$eNum\n";
		if(!defined($fNum) || !defined($eNum) || $fNum >= $eNum || $eRoot ne $fRoot) { push @nodes, $node; next; }
	
		my $prefix;
		foreach my $suffix ($fNum .. $eNum)
		  {
			my $numOfZeros = (length($fNum) - length($suffix));
			my $prefix = '0' x $numOfZeros;
			push @nodes, "$fRoot$prefix$suffix";
		  }
	  }

	return @nodes;
  }


# Take the reference to an array of node names and resolve each name to its
# primary hostname and then eliminate duplicates in the list.  Returns a reference
# to a new array.  This function is separate from gatherNodeList because it is
# rather expensive to do all the name resolutions, so this should only be called
# when necessary.  For example, if you are going to pass the node list to lsnode,
# lsnode will do this for you, so you do not need to call this.
# This function can also return a reference to a hash mapping each resolved name
# back to its original name.
sub resolveAndUndup
  {
	my ($class, $arrayref) = @_;
	NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'V', 'IMsgRESOLVING');
	my $hash = {};
	my $ar2 = [];
	foreach my $node (@$arrayref)
	  {
		my $hostname = NodeUtils->tryHost($node);
		if (!defined($$hash{$hostname}))
		  {
			$$hash{$hostname} = $node;
			push @$ar2, $hostname;
		  }
	  }
	if (wantarray) { return ($ar2, $hash); }
	else { return $ar2; }
  }


sub buildWhereInList
  {
	my ($class, $arrayref, $attrname) = @_;
	if (!defined($attrname) || !length($attrname)) { $attrname = 'Hostname'; }
	#todo: handle long cmd line
	my $where = qq/"$attrname IN ('/ . join("','",@$arrayref) . q/')"/;
	#my $comma = '';
	#foreach my $a (@$arrayref)
	#  {
	#	my $hostname = NodeUtils->tryHost($a);
	#	$where .= "$comma'$hostname'";
	#	$comma = ',';
	#  }
	#$where .= ')';
	return $where;
  }


# Return the expanded member list for each of the node group names passed in.
# A reference to an array will be returned.  Each element of the array represents
# 1 row and has the format:
#   nodegroupname:|:{node1,node2,node3}
sub listNodeGroupExpMem
  {
	shift;   # get rid of the class arg - the rest of @_ are the group names
	my $where = '';
	if (scalar(@_))
	  {
		# We do it this way instead of putting all the groups in one IN expression because
		# this way guarantees they will come back in the same order specified.
		foreach my $g (@_) { $where .= qq( -s IBM.NodeGroup::"Name='$g'"::Name::ExpMemberList); }
	  }
	else { $where = '-s IBM.NodeGroup::::Name::ExpMemberList'; }

	# Get the data
	my $outref = NodeUtils->runrmccmd('lsrsrc-api', "-i -D ':|:'", $where);
	if (scalar(@_) && scalar(@$outref)<scalar(@_))
	  {
		if (scalar(@_)==1) { NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'W', 'EMsgGROUP_NOT_FOUND', $_[0]); }
		else { NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'W', 'EMsgSOME_GROUPS_NOT_FOUND', join(',',@_)); }
	  }
	return $outref;
  }


# Does @$g1-@$g2 and returns the resulting array.
# The arrays passed in and the array returned are all references.  If $intersect
# is 1, then it finds the intersection of @$g1 and @$g2 instead.
sub subtractOrIntersect
  {
	my ($class, $g1, $g2, $intersect) = @_;
	if ($intersect) { $intersect = 1; }   # we need it exactly 0 or 1
	else { $intersect = 0; }
	
	# make a hash out of g2
	my %g2hash;
	@g2hash{@$g2} = (1) x scalar(@$g2);
	#foreach (@$g2) { $g2hash{$_}++; }
	
	# go through @g1 and only copy elements to the returned array that are not in
	# %g2hash
	my $out = [];
	# this cryptic line says: if the element of g1 is not in g2 and we are
	# doing a subtraction, then add it to the out arrary.  Or if the element
	# of g1 is in g2 and we are doing the intersection, then add it to out.
	foreach my $g (@$g1) { if (defined($g2hash{$g})==$intersect) { push @$out, $g; }}
	return $out;
  }


# Compares 2 arrays and returns true if they are the same length and all of
# their elements are equal.  Both arrays are references.
sub equalArrays
  {
    my ($class, $a1, $a2) = @_;
    my $len1 = scalar(@$a1);
    if ($len1 != scalar(@$a2)) { return 0; }
    for (my $i=0; $i<$len1; $i++) { if ($$a1[$i] ne $$a2[$i]) { return 0; } }
    return 1;
  }


#-----------------------------------------------------------------------------
#
# add_cluster_nl
#
# Get hosts currently in CSM and add to the node list.
# uses $main::lsnodes_opt as the flag to lsnodes command
#
#-----------------------------------------------------------------------------

sub add_cluster_nl {

   my ($hostname,@hostnames);
   my $optcsmdir = "/opt/csm/bin";

   if (!-x "$optcsmdir/lsnode") {
      print STDERR "Cluster System Management (csm.server) lsnode command not installed\n";
      exit(-1);
   }
   # get the long hostname from CSM lsnode
   chop(@hostnames = `$optcsmdir/lsnode $::lsnodes_opt 2>/dev/null`);
   # user specified -a and lsnode failed then exit
   if ($? != 0) {
      print STDERR "Cluster System Management lsnodes command error\n";
      exit(-1);
   }

   foreach $hostname (@hostnames) {
      NodeUtils->add_nl($hostname);
   }
}

#-----------------------------------------------------------------------------
#
# add_nl
#
# Add a host to the node list. Don't add a hostname if it is already there
# or if the is contained in another name which resolves to the same  host.
# Input is the hostname to add.
# Modifies @main::nl, where it stores the list of nodes
#
#-----------------------------------------------------------------------------

sub add_nl {

   shift;     # get rid of the class
   my $host = shift;
   my($hostname,@hostnames);
   my($newname,$name,$aliases,$addtype,$length,@addrs);
   $host =~ s/\s//g;
   # Now loop through hosts and return if the host is found
   foreach $hostname (@::nl) {
      # before adding-  check to see if either hostnames are a shortname 
      # for the same host
      if ($hostname =~ /^$host.*/ | $host =~ /^$hostname.*/ ) {
         # resolve hostname of new host to be added to list
         ($name,$aliases,$addtype,$length,@addrs) = gethostbyname($host);
         unless ($name) {
              print STDERR "Could not resolve hostname $host\n";
              return(1);
         }
         $newname = $name;
         # resolve hostname of existing node list host
         ($name,$aliases,$addtype,$length,@addrs) = gethostbyname($hostname);
         unless ($name) {
              print STDERR "Could not resolve hostname $host\n";
              return(1);
         }
         # If both names resolve to the same hostname, then do not add the host
         if ($name eq $newname) {
              return;
         }
      }
   }
   # Did not already have this host - add it to node list @::nl
   push(@::nl,$host);
}

1;
